/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
UserClient._rpcClient;

/**
 * URL
 */
UserClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
UserClient.prototype._domainUid;

/**
 * @constructor
 */ 
function UserClient(base, sid , domainUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/users/{domainUid}';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
};

UserClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
UserClient.prototype.getPhoto = function( uid  ) {
  let url = this._baseUrl + "/{uid}/photo";

  url = url.replace("{uid}", uid);

  let responseType = "";
  responseType = "arraybuffer";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.deletePhoto = function( uid  ) {
  let url = this._baseUrl + "/{uid}/photo";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.getIcon = function( uid  ) {
  let url = this._baseUrl + "/{uid}/icon";

  url = url.replace("{uid}", uid);

  let responseType = "";
  responseType = "arraybuffer";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.setPhoto = function( uid ,  arg1  ) {
  let url = this._baseUrl + "/{uid}/photo";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.setExtId = function( uid ,  arg1  ) {
  let url = this._baseUrl + "/{uid}/_extId";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.memberOf = function( uid  ) {
  let url = this._baseUrl + "/{uid}/groups";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.memberOfGroups = function( uid  ) {
  let url = this._baseUrl + "/{uid}/groupUids";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.setPassword = function( uid ,  password  ) {
  let url = this._baseUrl + "/{uid}/password_";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = password;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.allUids = function() {
  let url = this._baseUrl + "/_alluids";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.update = function( uid ,  user  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = user;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.getVCard = function( uid  ) {
  let url = this._baseUrl + "/{uid}/vcard";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.updateAccountType = function( uid ,  accountType  ) {
  let url = this._baseUrl + "/_updateAccountType/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = accountType;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.getResolvedRoles = function( uid  ) {
  let url = this._baseUrl + "/{uid}/roles_resolved";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.byLogin = function( login  ) {
  let url = this._baseUrl + "/byLogin/{login}";

  url = url.replace("{login}", login);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.byEmail = function( email  ) {
  let url = this._baseUrl + "/byEmail/{email}";

  url = url.replace("{email}", email);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.create = function( uid ,  user  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = user;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.setRoles = function( uid ,  roles  ) {
  let url = this._baseUrl + "/{uid}/roles";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = roles;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.getRoles = function( uid  ) {
  let url = this._baseUrl + "/{uid}/roles";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.updateVCard = function( uid ,  userVCard  ) {
  let url = this._baseUrl + "/{uid}/vcard";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = userVCard;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.byExtId = function( extid  ) {
  let url = this._baseUrl + "/byExtId/{extid}";

  url = url.replace("{extid}", extid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.getUsersWithRoles = function( roles  ) {
  let url = this._baseUrl + "/_roleusers";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = roles;
  return this._execute(cmd, body);
};

/*
 *
 */
UserClient.prototype.createWithExtId = function( uid ,  extid ,  user  ) {
  let url = this._baseUrl + "/{uid}/{extid}/createwithextid";

  url = url.replace("{uid}", uid);
  url = url.replace("{extid}", extid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = user;
  return this._execute(cmd, body);
};

UserClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
