/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
PublishCalendarClient._rpcClient;

/**
 * URL
 */
PublishCalendarClient._baseUrl;

/**
 * @type {string} containerUid
 * @private
 */
PublishCalendarClient.prototype._containerUid;

/**
 * @constructor
 */ 
function PublishCalendarClient(base, sid , containerUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/calendars/publish/{containerUid}';
  
  this._containerUid = containerUid;
  this._baseUrl = this._baseUrl.replace('{containerUid}',containerUid);
};

PublishCalendarClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
PublishCalendarClient.prototype.generateUrl = function( mode  ) {
  let url = this._baseUrl + "/_generate/{mode}";

  url = url.replace("{mode}", mode);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
PublishCalendarClient.prototype.disableUrl = function( url  ) {
  let url = this._baseUrl + "/_disable";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = url;
  return this._execute(cmd, body);
};

/*
 *
 */
PublishCalendarClient.prototype.getGeneratedUrls = function( mode  ) {
  let url = this._baseUrl + "/generated/{mode}";

  url = url.replace("{mode}", mode);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
PublishCalendarClient.prototype.publish = function( token  ) {
  let url = this._baseUrl + "/{token}";

  url = url.replace("{token}", token);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
PublishCalendarClient.prototype.createUrl = function( mode ,  token  ) {
  let url = this._baseUrl + "/_create/{mode}";

  url = url.replace("{mode}", mode);

  url += "?token=" + encodeURIComponent(token);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  return this._execute(cmd, body);
};

PublishCalendarClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
