/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
OwnerSubscriptionsClient._rpcClient;

/**
 * URL
 */
OwnerSubscriptionsClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
OwnerSubscriptionsClient.prototype._domainUid;

/**
 * @type {string} ownerUid
 * @private
 */
OwnerSubscriptionsClient.prototype._ownerUid;

/**
 * @constructor
 */ 
function OwnerSubscriptionsClient(base, sid , domainUid , ownerUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/containers/_subscriptions/{domainUid}/{ownerUid}';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
  this._ownerUid = ownerUid;
  this._baseUrl = this._baseUrl.replace('{ownerUid}',ownerUid);
};

OwnerSubscriptionsClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.getVersion = function() {
  let url = this._baseUrl + "/_version";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.filteredChangesetById = function( since ,  filter  ) {
  let url = this._baseUrl + "/_filteredChangesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = filter;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.itemChangelog = function( uid ,  since  ) {
  let url = this._baseUrl + "/{uid}/_itemchangelog";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = since;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.changeset = function( since  ) {
  let url = this._baseUrl + "/_changeset";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.changesetById = function( since  ) {
  let url = this._baseUrl + "/_changesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.containerChangelog = function( since  ) {
  let url = this._baseUrl + "/_changelog";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = since;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.allIds = function( filter ,  knownContainerVersion ,  limit ,  offset  ) {
  let url = this._baseUrl + "/_itemIds";


  url += "?filter=" + encodeURIComponent(filter);
  url += "&knownContainerVersion=" + encodeURIComponent(knownContainerVersion);
  url += "&limit=" + encodeURIComponent(limit);
  url += "&offset=" + encodeURIComponent(offset);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.list = function() {
  let url = this._baseUrl + "/_list";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.getMultipleById = function( id  ) {
  let url = this._baseUrl + "/_mgetById";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = id;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.getMultiple = function( uids  ) {
  let url = this._baseUrl + "/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = uids;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.fullChangesetById = function( since  ) {
  let url = this._baseUrl + "/_fullChangesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OwnerSubscriptionsClient.prototype.getCompleteById = function( id  ) {
  let url = this._baseUrl + "/{id}/completeById";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

OwnerSubscriptionsClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
