/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
OrgUnitsClient._rpcClient;

/**
 * URL
 */
OrgUnitsClient._baseUrl;

/**
 * @type {string} domain
 * @private
 */
OrgUnitsClient.prototype._domain;

/**
 * @constructor
 */ 
function OrgUnitsClient(base, sid , domain ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/directory/_ou/{domain}';
  
  this._domain = domain;
  this._baseUrl = this._baseUrl.replace('{domain}',domain);
};

OrgUnitsClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
OrgUnitsClient.prototype.getAdministratorRoles = function( uid ,  dirUid ,  groups  ) {
  let url = this._baseUrl + "/{uid}/{dirUid}";

  url = url.replace("{uid}", uid);
  url = url.replace("{dirUid}", dirUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = groups;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.setAdministratorRoles = function( uid ,  dirUid ,  roles  ) {
  let url = this._baseUrl + "/{uid}/{dirUid}/_set";

  url = url.replace("{uid}", uid);
  url = url.replace("{dirUid}", dirUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = roles;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.update = function( uid ,  value  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = value;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.removeAdministrator = function( administrator  ) {
  let url = this._baseUrl + "/_deleteadmin";


  url += "?administrator=" + encodeURIComponent(administrator);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.getAdministrators = function( uid ,  hierarchical  ) {
  let url = this._baseUrl + "/{uid}/_administrators";

  url = url.replace("{uid}", uid);

  url += "?hierarchical=" + encodeURIComponent(hierarchical);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.getChildren = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_children";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.search = function( query  ) {
  let url = this._baseUrl + "/_search";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.getPath = function( uid  ) {
  let url = this._baseUrl + "/{uid}/path";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.create = function( uid ,  value  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = value;
  return this._execute(cmd, body);
};

/*
 *
 */
OrgUnitsClient.prototype.listByAdministrator = function( administrator ,  groups  ) {
  let url = this._baseUrl + "/_byAdmin";


  url += "?administrator=" + encodeURIComponent(administrator);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = groups;
  return this._execute(cmd, body);
};

OrgUnitsClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
