/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
MailboxesClient._rpcClient;

/**
 * URL
 */
MailboxesClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
MailboxesClient.prototype._domainUid;

/**
 * @constructor
 */ 
function MailboxesClient(base, sid , domainUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/mailboxes/{domainUid}';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
};

MailboxesClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxConfig = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_config";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.update = function( uid ,  mailbox  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = mailbox;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.byName = function( name  ) {
  let url = this._baseUrl + "/_byname";


  url += "?name=" + encodeURIComponent(name);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.setMailboxFilter = function( mailboxUid ,  filter  ) {
  let url = this._baseUrl + "/{mailboxUid}/_filter";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = filter;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getUnreadMessagesCount = function() {
  let url = this._baseUrl + "/_unread";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.listUids = function() {
  let url = this._baseUrl + "/_listUids";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.setMailboxAccessControlList = function( mailboxUid ,  accessControlEntries  ) {
  let url = this._baseUrl + "/{mailboxUid}/_acls";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = accessControlEntries;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.byEmail = function( email  ) {
  let url = this._baseUrl + "/_byemail";


  url += "?email=" + encodeURIComponent(email);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.create = function( uid ,  mailbox  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = mailbox;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.byRouting = function( email  ) {
  let url = this._baseUrl + "/_byRouting";


  url += "?email=" + encodeURIComponent(email);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.checkAll = function() {
  let url = this._baseUrl + "/_check-all";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.multipleGet = function( uids  ) {
  let url = this._baseUrl + "/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = uids;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.checkAndRepair = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_check-and-repair";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxFilter = function( mailboxUid  ) {
  let url = this._baseUrl + "/{mailboxUid}/_filter";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxAccessControlList = function( mailboxUid  ) {
  let url = this._baseUrl + "/{mailboxUid}/_acls";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.check = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_check";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.list = function() {
  let url = this._baseUrl + "/_list";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.setDomainFilter = function( filter  ) {
  let url = this._baseUrl + "/_filter";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = filter;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxQuota = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_quota";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getDomainFilter = function() {
  let url = this._baseUrl + "/_filter";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.byType = function( email  ) {
  let url = this._baseUrl + "/_byType";


  url += "?email=" + encodeURIComponent(email);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.checkAndRepairAll = function() {
  let url = this._baseUrl + "/_check-and-repair-all";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

MailboxesClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
