/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
HSMClient._rpcClient;

/**
 * URL
 */
HSMClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
HSMClient.prototype._domainUid;

/**
 * @constructor
 */ 
function HSMClient(base, sid , domainUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/hsm/{domainUid}';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
};

HSMClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
HSMClient.prototype.promoteMultiple = function( promote  ) {
  let url = this._baseUrl + "/_massPromote";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = promote;
  return this._execute(cmd, body);
};

/*
 *
 */
HSMClient.prototype.getSize = function( mailboxUid  ) {
  let url = this._baseUrl + "/_getSize/{mailboxUid}";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
HSMClient.prototype.fetch = function( mailboxUid ,  hsmId  ) {
  let url = this._baseUrl + "/_fetch/{mailboxUid}/{hsmId}";

  url = url.replace("{mailboxUid}", mailboxUid);
  url = url.replace("{hsmId}", hsmId);

  let responseType = "";
  responseType = "arraybuffer";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
HSMClient.prototype.copy = function( sourceMailboxUid ,  destMailboxUid ,  hsmIds  ) {
  let url = this._baseUrl + "/_copy/{sourceMailboxUid}/{destMailboxUid}";

  url = url.replace("{sourceMailboxUid}", sourceMailboxUid);
  url = url.replace("{destMailboxUid}", destMailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = hsmIds;
  return this._execute(cmd, body);
};

HSMClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
