/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
DirectoryClient._rpcClient;

/**
 * URL
 */
DirectoryClient._baseUrl;

/**
 * @type {string} domain
 * @private
 */
DirectoryClient.prototype._domain;

/**
 * @constructor
 */ 
function DirectoryClient(base, sid , domain ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/directory/{domain}';
  
  this._domain = domain;
  this._baseUrl = this._baseUrl.replace('{domain}',domain);
};

DirectoryClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
DirectoryClient.prototype.getEntryIcon = function( entryUid  ) {
  let url = this._baseUrl + "/entry-uid/{entryUid}/icon";

  url = url.replace("{entryUid}", entryUid);

  let responseType = "";
  responseType = "arraybuffer";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getVCard = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_vcard";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.delete_ = function( path  ) {
  let url = this._baseUrl + "/{path}";

  url = url.replace("{path}", path);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.changeset = function( since  ) {
  let url = this._baseUrl + "/_changeset";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getByRoles = function( roles  ) {
  let url = this._baseUrl + "/_byroles";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = roles;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.search = function( query  ) {
  let url = this._baseUrl + "/_search";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.findByEntryUid = function( entryUid  ) {
  let url = this._baseUrl + "/entry-uid/{entryUid}";

  url = url.replace("{entryUid}", entryUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getMultiple = function( id  ) {
  let url = this._baseUrl + "/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = id;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getEntryPhoto = function( entryUid  ) {
  let url = this._baseUrl + "/entry-uid/{entryUid}/photo";

  url = url.replace("{entryUid}", entryUid);

  let responseType = "";
  responseType = "arraybuffer";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getEntry = function( path  ) {
  let url = this._baseUrl + "/_entry";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = path;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getRoot = function() {
  let url = this._baseUrl;


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.deleteByEntryUid = function( entryUid  ) {
  let url = this._baseUrl + "/_byentryuid/{entryUid}";

  url = url.replace("{entryUid}", entryUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.xfer = function( entryUid ,  serverUid  ) {
  let url = this._baseUrl + "/_xfer/{entryUid}/{serverUid}";

  url = url.replace("{entryUid}", entryUid);
  url = url.replace("{serverUid}", serverUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getByEmail = function( email  ) {
  let url = this._baseUrl + "/_byEmail/{email}";

  url = url.replace("{email}", email);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getRolesForDirEntry = function( entryUid  ) {
  let url = this._baseUrl + "/entry-uid/{entryUid}/rolesfor_";

  url = url.replace("{entryUid}", entryUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.changelog = function( since  ) {
  let url = this._baseUrl + "/_changelog";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getRolesForOrgUnit = function( ouUid  ) {
  let url = this._baseUrl + "/ou-uid/{ouUid}/rolesfor_";

  url = url.replace("{ouUid}", ouUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getIcon = function( path  ) {
  let url = this._baseUrl + "/_icon/{path}";

  url = url.replace("{path}", path);

  let responseType = "";
  responseType = "arraybuffer";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirectoryClient.prototype.getEntries = function( path  ) {
  let url = this._baseUrl + "/_childs";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = path;
  return this._execute(cmd, body);
};

DirectoryClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
