/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
ChangelogSupportClient._rpcClient;

/**
 * URL
 */
ChangelogSupportClient._baseUrl;

/**
 * @constructor
 */ 
function ChangelogSupportClient(base, sid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api';
  
};

ChangelogSupportClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
ChangelogSupportClient.prototype.getVersion = function() {
  let url = this._baseUrl + "/_version";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ChangelogSupportClient.prototype.filteredChangesetById = function( since ,  filter  ) {
  let url = this._baseUrl + "/_filteredChangesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = filter;
  return this._execute(cmd, body);
};

/*
 *
 */
ChangelogSupportClient.prototype.itemChangelog = function( uid ,  since  ) {
  let url = this._baseUrl + "/{uid}/_itemchangelog";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = since;
  return this._execute(cmd, body);
};

/*
 *
 */
ChangelogSupportClient.prototype.changeset = function( since  ) {
  let url = this._baseUrl + "/_changeset";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ChangelogSupportClient.prototype.changesetById = function( since  ) {
  let url = this._baseUrl + "/_changesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ChangelogSupportClient.prototype.containerChangelog = function( since  ) {
  let url = this._baseUrl + "/_changelog";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = since;
  return this._execute(cmd, body);
};

/*
 *
 */
ChangelogSupportClient.prototype.allIds = function( filter ,  knownContainerVersion ,  limit ,  offset  ) {
  let url = this._baseUrl + "/_itemIds";


  url += "?filter=" + encodeURIComponent(filter);
  url += "&knownContainerVersion=" + encodeURIComponent(knownContainerVersion);
  url += "&limit=" + encodeURIComponent(limit);
  url += "&offset=" + encodeURIComponent(offset);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

ChangelogSupportClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
