/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
CalendarClient._rpcClient;

/**
 * URL
 */
CalendarClient._baseUrl;

/**
 * @type {string} containerUid
 * @private
 */
CalendarClient.prototype._containerUid;

/**
 * @constructor
 */ 
function CalendarClient(base, sid , containerUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/calendars/{containerUid}';
  
  this._containerUid = containerUid;
  this._baseUrl = this._baseUrl.replace('{containerUid}',containerUid);
};

CalendarClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
CalendarClient.prototype.getVersion = function() {
  let url = this._baseUrl + "/_version";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.filteredChangesetById = function( since ,  arg1  ) {
  let url = this._baseUrl + "/_filteredChangesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.itemChangelog = function( uid ,  arg1  ) {
  let url = this._baseUrl + "/{uid}/_itemchangelog";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.changeset = function( since  ) {
  let url = this._baseUrl + "/_changeset";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.changesetById = function( since  ) {
  let url = this._baseUrl + "/_changesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.containerChangelog = function( arg0  ) {
  let url = this._baseUrl + "/_changelog";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.allIds = function( filter ,  knownContainerVersion ,  limit ,  offset  ) {
  let url = this._baseUrl + "/_itemIds";


  url += "?filter=" + encodeURIComponent(filter);
  url += "&knownContainerVersion=" + encodeURIComponent(knownContainerVersion);
  url += "&limit=" + encodeURIComponent(limit);
  url += "&offset=" + encodeURIComponent(offset);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.multipleGetById = function( arg0  ) {
  let url = this._baseUrl + "/_mgetById";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.getCompleteById = function( id  ) {
  let url = this._baseUrl + "/{id}/completeById";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.multipleDeleteById = function( arg0  ) {
  let url = this._baseUrl + "/_multipleDelete";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.updateById = function( id ,  arg1  ) {
  let url = this._baseUrl + "/id/{id}";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.deleteById = function( id  ) {
  let url = this._baseUrl + "/id/{id}";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.createById = function( id ,  arg1  ) {
  let url = this._baseUrl + "/id/{id}";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.count = function( arg0  ) {
  let url = this._baseUrl + "/_count";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.sortedIds = function( arg0  ) {
  let url = this._baseUrl + "/_sorted";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.update = function( uid ,  event ,  sendNotifications  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  url += "?sendNotifications=" + encodeURIComponent(sendNotifications);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = event;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.updates = function( changes  ) {
  let url = this._baseUrl + "/_mupdates";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = changes;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.delete_ = function( uid ,  sendNotifications  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  url += "?sendNotifications=" + encodeURIComponent(sendNotifications);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.search = function( query  ) {
  let url = this._baseUrl + "/_search";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.create = function( uid ,  event ,  sendNotifications  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  url += "?sendNotifications=" + encodeURIComponent(sendNotifications);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = event;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.all = function() {
  let url = this._baseUrl + "/_all";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.multipleGet = function( uids  ) {
  let url = this._baseUrl + "/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = uids;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.touch = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_touch";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.list = function() {
  let url = this._baseUrl + "/_list";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.sync = function( since ,  changes  ) {
  let url = this._baseUrl + "/_sync";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = changes;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.isAutoSyncActivated = function() {
  let url = this._baseUrl + "/_isAutoSyncActivated";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.searchPendingCounters = function() {
  let url = this._baseUrl + "/_search_counters";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.reset = function() {
  let url = this._baseUrl + "/_reset";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
CalendarClient.prototype.getByIcsUid = function( uid  ) {
  let url = this._baseUrl + "/_icsuid/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

CalendarClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
