/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.hsm.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class PromoteGwtSerDer implements GwtSerDer<net.bluemind.hsm.api.Promote> {

	public PromoteGwtSerDer( ) {
	}

	@Override
	public net.bluemind.hsm.api.Promote deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.hsm.api.Promote ret = new net.bluemind.hsm.api.Promote();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.hsm.api.Promote ret, JSONObject json) {

		JSONValue mailboxUidJSON = json.get("mailboxUid");
		ret.mailboxUid =  GwtSerDerUtils.STRING.deserialize(mailboxUidJSON);
		JSONValue folderJSON = json.get("folder");
		ret.folder =  GwtSerDerUtils.STRING.deserialize(folderJSON);
		JSONValue hsmIdJSON = json.get("hsmId");
		ret.hsmId =  GwtSerDerUtils.STRING.deserialize(hsmIdJSON);
		JSONValue imapUidJSON = json.get("imapUid");
		ret.imapUid =  GwtSerDerUtils.INT.deserialize(imapUidJSON);
		JSONValue internalDateJSON = json.get("internalDate");
		ret.internalDate =  GwtSerDerUtils.DATE.deserialize(internalDateJSON);
		JSONValue flagsJSON = json.get("flags");
		ret.flags =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(flagsJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.hsm.api.Promote o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.hsm.api.Promote o, JSONObject ret) {

		ret.put("mailboxUid",  GwtSerDerUtils.STRING.serialize( o.mailboxUid ));
		ret.put("folder",  GwtSerDerUtils.STRING.serialize( o.folder ));
		ret.put("hsmId",  GwtSerDerUtils.STRING.serialize( o.hsmId ));
		ret.put("imapUid",  GwtSerDerUtils.INT.serialize( o.imapUid ));
		ret.put("internalDate",  GwtSerDerUtils.DATE.serialize( o.internalDate ));
		ret.put("flags",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.flags ));
	}
}