/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.hsm.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class HSMGwtEndpoint implements net.bluemind.hsm.api.IHSMAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public HSMGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/hsm/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public HSMGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void promoteMultiple(List<net.bluemind.hsm.api.Promote> promote, final AsyncHandler<List<net.bluemind.hsm.api.TierChangeResult>> handler) {
		String postUri = "/_massPromote";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(new net.bluemind.hsm.api.gwt.serder.PromoteGwtSerDer()).serialize( promote);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.hsm.api.TierChangeResult>>(handler) {
			@Override
			protected List<net.bluemind.hsm.api.TierChangeResult> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.hsm.api.gwt.serder.TierChangeResultGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getSize(String mailboxUid, final AsyncHandler<Double> handler) {
		String postUri = "/_getSize/{mailboxUid}";

		postUri = postUri.replace("{mailboxUid}", ""+mailboxUid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Double>(handler) {
			@Override
			protected Double handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.DOUBLE.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void fetch(String mailboxUid, String hsmId, final AsyncHandler<byte[]> handler) {
		String postUri = "/_fetch/{mailboxUid}/{hsmId}";

		postUri = postUri.replace("{mailboxUid}", ""+mailboxUid);
		postUri = postUri.replace("{hsmId}", ""+hsmId);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<byte[]>(handler) {
			@Override
			protected byte[] handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ByteArraySerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void copy(String sourceMailboxUid, String destMailboxUid, List<String> hsmIds, final AsyncHandler<Void> handler) {
		String postUri = "/_copy/{sourceMailboxUid}/{destMailboxUid}";

		postUri = postUri.replace("{sourceMailboxUid}", ""+sourceMailboxUid);
		postUri = postUri.replace("{destMailboxUid}", ""+destMailboxUid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( hsmIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.hsm.api.IHSMPromise promiseApi() {
		return new HSMEndpointPromise(this);
	}
}
