/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.hsm.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class HSMEndpointPromise implements net.bluemind.hsm.api.IHSMPromise {

	private net.bluemind.hsm.api.IHSMAsync impl;

	public HSMEndpointPromise(net.bluemind.hsm.api.IHSMAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.hsm.api.TierChangeResult>> promoteMultiple(List<net.bluemind.hsm.api.Promote> promote  ) {
		
		CompletableFuture<List<net.bluemind.hsm.api.TierChangeResult>> ret = new CompletableFuture<List<net.bluemind.hsm.api.TierChangeResult>>();
		AsyncHandler<List<net.bluemind.hsm.api.TierChangeResult>> handler = new AsyncHandler<List<net.bluemind.hsm.api.TierChangeResult>>() {
			public void success(List<net.bluemind.hsm.api.TierChangeResult> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.promoteMultiple(promote,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Double> getSize(String mailboxUid  ) {
		
		CompletableFuture<Double> ret = new CompletableFuture<Double>();
		AsyncHandler<Double> handler = new AsyncHandler<Double>() {
			public void success(Double value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getSize(mailboxUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<byte[]> fetch(String mailboxUid ,  String hsmId  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.fetch(mailboxUid, hsmId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> copy(String sourceMailboxUid ,  String destMailboxUid ,  List<String> hsmIds  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.copy(sourceMailboxUid, destMailboxUid, hsmIds,  handler);
		return ret;
	}

}
