<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2017
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
namespace BM;
require_once 'GlobalEnv.php';

/**
 * Implementation of net.bluemind.backend.mail.api.IMailboxItems.
 */

class MailboxItemsClient {

  protected $base;
  protected $sid;
  protected $replicatedMailboxUid;

  /*
   * Constructor.
   *
   * @param base
   * @param sid
   * @param replicatedMailboxUid
   *
   */
  public function __construct($base, $sid , $replicatedMailboxUid) {
    $this->sid = $sid;
    $this->base = $base."/api/mail_items/{replicatedMailboxUid}";
    $this->replicatedMailboxUid = $replicatedMailboxUid;
    $this->base = str_replace("{replicatedMailboxUid}", urlencode($replicatedMailboxUid), $this->base);
  }


  /*
   * @return
   */
  public function getVersion() {
    $postUri = "/_version";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param since
   * @param arg1
   * @return
   */
  public function filteredChangesetById( $since ,  $arg1  ) {
    $postUri = "/_filteredChangesetById";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array(
      "since" => $since);

    $body = null;
    $body = $arg1;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param arg1
   * @return
   */
  public function itemChangelog( $uid ,  $arg1  ) {
    $postUri = "/{uid}/_itemchangelog";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg1;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param since
   * @return
   */
  public function changeset( $since  ) {
    $postUri = "/_changeset";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "since" => $since);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param since
   * @return
   */
  public function changesetById( $since  ) {
    $postUri = "/_changesetById";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "since" => $since);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @return
   */
  public function containerChangelog( $arg0  ) {
    $postUri = "/_changelog";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param filter
   * @param knownContainerVersion
   * @param limit
   * @param offset
   * @return
   */
  public function allIds( $filter ,  $knownContainerVersion ,  $limit ,  $offset  ) {
    $postUri = "/_itemIds";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "filter" => $filter,      "knownContainerVersion" => $knownContainerVersion,      "limit" => $limit,      "offset" => $offset);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @return
   */
  public function multipleGetById( $arg0  ) {
    $postUri = "/_mgetById";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @return
   */
  public function getCompleteById( $id  ) {
    $postUri = "/{id}/completeById";
    $method = "GET";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @return
   */
  public function multipleDeleteById( $arg0  ) {
    $postUri = "/_multipleDelete";
    $method = "DELETE";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @param arg1
   * @return
   */
  public function updateById( $id ,  $arg1  ) {
    $postUri = "/id/{id}";
    $method = "POST";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg1;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @return
   */
  public function deleteById( $id  ) {
    $postUri = "/id/{id}";
    $method = "DELETE";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @param arg1
   * @return
   */
  public function createById( $id ,  $arg1  ) {
    $postUri = "/id/{id}";
    $method = "PUT";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg1;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @return
   */
  public function count( $arg0  ) {
    $postUri = "/_count";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param arg0
   * @return
   */
  public function sortedIds( $arg0  ) {
    $postUri = "/_sorted";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg0;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @return
   */
  public function getForUpdate( $id  ) {
    $postUri = "/{id}/getForUpdate";
    $method = "GET";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param flagUpdate
   * @return
   */
  public function deleteFlag( $flagUpdate  ) {
    $postUri = "/_deleteFlag";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $flagUpdate;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function unreadItems() {
    $postUri = "/_unread";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param part
   * @return
   */
  public function uploadPart( $part  ) {
    $postUri = "/_part";
    $method = "PUT";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $part;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param value
   * @return
   */
  public function create( $value  ) {
    $postUri = "";
    $method = "PUT";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $value;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param deliveredOrUpdatedAfter
   * @return
   */
  public function recentItems( $deliveredOrUpdatedAfter  ) {
    $postUri = "/_recent";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $deliveredOrUpdatedAfter;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param itemId
   * @return
   */
  public function unexpunge( $itemId  ) {
    $postUri = "/_unexpunge/{itemId}";
    $method = "POST";

    $postUri = str_replace("{itemId}", urlencode($itemId), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function expunge() {
    $postUri = "/_expunge";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param imapUid
   * @return
   */
  public function fetchComplete( $imapUid  ) {
    $postUri = "/eml/{imapUid}";
    $method = "GET";

    $postUri = str_replace("{imapUid}", urlencode($imapUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param flagUpdate
   * @return
   */
  public function addFlag( $flagUpdate  ) {
    $postUri = "/_addFlag";
    $method = "PUT";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $flagUpdate;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param partId
   * @return
   */
  public function removePart( $partId  ) {
    $postUri = "/{partId}/_part";
    $method = "DELETE";

    $postUri = str_replace("{partId}", urlencode($partId), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param ids
   * @return
   */
  public function multipleById( $ids  ) {
    $postUri = "/_multipleById";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $ids;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param imapUid
   * @param address
   * @param encoding
   * @param mime
   * @param charset
   * @param filename
   * @return
   */
  public function fetch( $imapUid ,  $address ,  $encoding ,  $mime ,  $charset ,  $filename  ) {
    $postUri = "/part/{imapUid}/{address}";
    $method = "GET";

    $postUri = str_replace("{imapUid}", urlencode($imapUid), $postUri);
    $postUri = str_replace("{address}", urlencode($address), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array(
      "encoding" => $encoding,      "mime" => $mime,      "charset" => $charset,      "filename" => $filename);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }


  /*
   * Execute the request
   *
   * @param url
   * @param data
   * @param body
   */
  private function execute($url, $queryParam, $body, $method) {

    $curl = curl_init();

    $headers = array();
    array_push($headers, 'X-BM-ApiKey: '.$this->sid);

    if (sizeof($queryParam) > 0) {
      $url .= '?'.http_build_query($queryParam);
    }

    curl_setopt_array($curl, GlobalEnv::$curlOptions + array(
      CURLOPT_URL => $url,
      CURLOPT_HTTPHEADER => $headers,
      CURLOPT_CUSTOMREQUEST => $method)
    );

    if ($method == 'POST') {
      curl_setopt($curl, CURLOPT_POST, TRUE);
      curl_setopt($curl, CURLOPT_POSTFIELDS, array());
    }

    if (is_resource($body)) {
      if ($method == 'PUT') {
        curl_setopt($curl, CURLOPT_PUT, TRUE);
      }
      $size = fstat($body)['size'];
      curl_setopt($curl, CURLOPT_INFILE, $body);
      curl_setopt($curl, CURLOPT_INFILESIZE, $size);
    } else {
      if (is_object($body) && method_exists($body, 'serialize')) {
        $body = $body->serialize();
      } else if (is_object($body)) {
        $body = json_encode($body);
      } else if (is_array($body)) {
        $body = json_encode($body);
      } else if (is_string($body)) {
        $body = json_encode($body);
      }
      $size = strlen($body);
      array_push($headers, 'Content-Type: application/json');
      array_push($headers, 'Content-Length: '.$size);
      curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($curl, CURLOPT_POSTFIELDS, $body);
    }

    $resp = curl_exec($curl);
    if ($resp === false) {
      throw new \Exception(curl_error($curl));
    } 
    curl_close($curl);
    if (!$resp) {
      return;
    }
    $js = json_decode($resp);
    if ($js === NULL) {
      return $resp;
    }
    if (isset($js->errorCode)) {
      throw new \Exception($js->errorCode . ': ' . (isset($js->message) ? ' : ' . $js->message : ''));
    }
    return $js;
  }

}
