/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.externaluser.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ExternalUserGwtSerDer implements GwtSerDer<net.bluemind.externaluser.api.ExternalUser> {

    private net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer parent = new  net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer(); 
	public ExternalUserGwtSerDer( ) {
	}

	@Override
	public net.bluemind.externaluser.api.ExternalUser deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.externaluser.api.ExternalUser ret = new net.bluemind.externaluser.api.ExternalUser();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.externaluser.api.ExternalUser ret, JSONObject json) {
		parent.deserializeTo( ret, json);

		JSONValue contactInfosJSON = json.get("contactInfos");
		ret.contactInfos =  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().deserialize(contactInfosJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.externaluser.api.ExternalUser o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.externaluser.api.ExternalUser o, JSONObject ret) {
		parent.serializeTo( o, ret);

		ret.put("contactInfos",  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().serialize( o.contactInfos ));
	}
}