/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.webmodules.launcher;

import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import net.bluemind.jna.utils.MemlockSupport;
import net.bluemind.lib.vertx.VertxPlatform;
import net.bluemind.systemd.notify.Startup;

public class Launcher implements IApplication {

	@Override
	public Object start(IApplicationContext context) throws Exception {
		Platform.getExtensionRegistry();
		Handler<AsyncResult<Void>> done = new Handler<AsyncResult<Void>>() {

			@Override
			public void handle(AsyncResult<Void> event) {
				Startup.notifyReady();
				MemlockSupport.mlockallOrWarn();
			}
		};
		VertxPlatform.spawnVerticles(done);
		return IApplication.EXIT_OK;
	}

	@Override
	public void stop() {
		// ok

	}

}