/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.system.api.hot.upgrade
{
  [DataContract(Namespace="")]
  public partial class HotUpgradeTaskExcludeOperationFilter  {
    [DataMember]
    public List<String> excludedOperations = new List<String>();
    
    [IgnoreDataMember]
    public List<net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus> statuses = new List<net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus>();
    [DataMember(Name = "statuses")]
    public List<String> statusesSurrogate
    {
        get
        {
            return statuses == null ? null : statuses.Select(v => v.ToString()).ToList();
        }
        set
        {
            statuses = new List<net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus>();
            foreach (string s in value)
            {
                net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus e;
                if (Enum.TryParse(s, true, out e))
                {
                    statuses.Add(e);
                }
            }            
        }
    }
    
  
  }
}
