/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.system.api.hot.upgrade.IHotUpgrade.
 */
namespace net.bluemind.system.api.hot.upgrade
{

  public class HotUpgradeClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public HotUpgradeClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/hot_upgrade";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask> running()
    {
      String methodVerb = "GET";
      String methodPathValue = "/running";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress> progress()
    {
      String methodVerb = "GET";
      String methodPathValue = "/progress";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask> list(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter filter )
    {
      String methodVerb = "POST";
      String methodPathValue = "/list";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, filter);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.system.api.hot.upgrade.HotUpgradeTask>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
