/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.system.api.ISecurityMgmt.
 */
namespace net.bluemind.system.api
{

  public class SecurityMgmtClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public SecurityMgmtClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/system/security";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public net.bluemind.core.task.api.TaskRef updateFirewallRules()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_updatefirewallrules";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef generateLetsEncrypt(net.bluemind.system.api.CertData certData )
    {
      String methodVerb = "POST";
      String methodPathValue = "/lets_encrypt";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.system.api.CertData));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, certData);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void approveLetsEncryptTos(String uid )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/lets_encrypt_tos/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateCertificate(net.bluemind.system.api.CertData certData )
    {
      String methodVerb = "POST";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.system.api.CertData));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, certData);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getLetsEncryptTos()
    {
      String methodVerb = "GET";
      String methodPathValue = "/lets_encrypt_tos";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
