/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.scheduledjob.api
{
  [DataContract(Namespace="")]
  public partial class JobExecutionQuery  {
    [DataMember]
    public String jobId;
    
    [DataMember]
    public String domain;
    
    [DataMember]
    public int? id;
    
    [IgnoreDataMember]
    public List<net.bluemind.scheduledjob.api.JobExitStatus> statuses = new List<net.bluemind.scheduledjob.api.JobExitStatus>();
    [DataMember(Name = "statuses")]
    public List<String> statusesSurrogate
    {
        get
        {
            return statuses == null ? null : statuses.Select(v => v.ToString()).ToList();
        }
        set
        {
            statuses = new List<net.bluemind.scheduledjob.api.JobExitStatus>();
            foreach (string s in value)
            {
                net.bluemind.scheduledjob.api.JobExitStatus e;
                if (Enum.TryParse(s, true, out e))
                {
                    statuses.Add(e);
                }
            }            
        }
    }
    
    [DataMember]
    public Boolean active;
    
    [DataMember]
    public int? from;
    
    [DataMember]
    public int? size;
    
  
  }
}
