/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.scheduledjob.api
{
  [DataContract(Namespace="")]
  public partial class Job  {
    [DataMember]
    public List<net.bluemind.scheduledjob.api.JobDomainStatus> domainStatus = new List<net.bluemind.scheduledjob.api.JobDomainStatus>();
    
    [DataMember]
    public List<net.bluemind.scheduledjob.api.JobPlanification> domainPlanification = new List<net.bluemind.scheduledjob.api.JobPlanification>();
    
    [DataMember]
    public String id;
    
    [DataMember]
    public String description;
    
    [IgnoreDataMember]
    public net.bluemind.scheduledjob.api.JobKind? kind;
    [DataMember(Name = "kind")]
    public String kindSurrogate
    {
        get
        {
            return kind.HasValue ? kind.ToString() : null;
        }
        set
        {
            net.bluemind.scheduledjob.api.JobKind e;
            kind = Enum.TryParse(value, true, out e) ? e : (net.bluemind.scheduledjob.api.JobKind?)null;
        }
    }
    
    [DataMember]
    public Boolean sendReport;
    
    [DataMember]
    public String recipients;
    
  
  }
}
