/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.role.api.IRoles.
 */
namespace net.bluemind.role.api
{

  public class RolesClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public RolesClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/roles";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public List<net.bluemind.role.api.RolesCategory> getRolesCategories()
    {
      String methodVerb = "GET";
      String methodPathValue = "/categories";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.role.api.RolesCategory>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.role.api.RoleDescriptor> getRoles()
    {
      String methodVerb = "GET";
      String methodPathValue = "/descriptors";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.role.api.RoleDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
