/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.resource.api.IResources.
 */
namespace net.bluemind.resource.api
{

  public class ResourcesClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public ResourcesClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/resources/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public String addToEventDescription(String uid, net.bluemind.resource.api.EventInfo eventInfo )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/addToEventDesc";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.resource.api.EventInfo));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, eventInfo);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public String removeFromEventDescription(String uid, net.bluemind.resource.api.EventInfo eventInfo )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/removeFromEventDesc";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.resource.api.EventInfo));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, eventInfo);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.resource.api.ResourceDescriptor resourceDescriptor )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.resource.api.ResourceDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, resourceDescriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getIcon(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/icon";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setIcon(String uid, byte[] icon )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/icon";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = icon;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.resource.api.ResourceDescriptor get(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.resource.api.ResourceDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.resource.api.ResourceDescriptor> byEmail(String email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byEmail/{email}";
      methodPathValue = methodPathValue.Replace("{email}", HttpUtility.UrlEncode("" + email));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.resource.api.ResourceDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.resource.api.ResourceDescriptor resourceDescriptor )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.resource.api.ResourceDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, resourceDescriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> byType(String type )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byType/{type}";
      methodPathValue = methodPathValue.Replace("{type}", HttpUtility.UrlEncode("" + type));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
