/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.notes.api
{
  [DataContract(Namespace="")]
  public partial class VNote  {
    [DataMember]
    public int? height;
    
    [DataMember]
    public int? width;
    
    [DataMember]
    public int? posX;
    
    [DataMember]
    public int? posY;
    
    [IgnoreDataMember]
    public net.bluemind.notes.api.VNoteColor? color;
    [DataMember(Name = "color")]
    public String colorSurrogate
    {
        get
        {
            return color.HasValue ? color.ToString() : null;
        }
        set
        {
            net.bluemind.notes.api.VNoteColor e;
            color = Enum.TryParse(value, true, out e) ? e : (net.bluemind.notes.api.VNoteColor?)null;
        }
    }
    
    [DataMember]
    public String body;
    
    [DataMember]
    public String subject;
    
    [DataMember]
    public List<net.bluemind.tag.api.TagRef> categories = new List<net.bluemind.tag.api.TagRef>();
    
  
  }
}
