/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.notes.api.INote.
 */
namespace net.bluemind.notes.api
{

  public class NoteClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public NoteClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/notes/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public long? getVersion()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_version";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<long?>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> filteredChangesetById(long? since, net.bluemind.core.container.model.ItemFlagFilter arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_filteredChangesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ItemFlagFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemChangelog itemChangelog(String uid, long? arg1 )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_itemchangelog";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(long?));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ItemChangelog>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<String> changeset(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changeset";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<long?> changesetById(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangelog containerChangelog(long? arg0 )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changelog";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(long?));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerChangelog>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<long?> allIds(String filter, long? knownContainerVersion, int? limit, int? offset )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_itemIds";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("filter", filter.ToString());
      queryParams.Add("knownContainerVersion", knownContainerVersion.ToString());
      queryParams.Add("limit", limit.ToString());
      queryParams.Add("offset", offset.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.api.ListResult<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Count count(net.bluemind.core.container.model.ItemFlagFilter arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_count";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ItemFlagFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Count>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> multipleGetById(List<long?> arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mgetById";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote> getCompleteById(long? id )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{id}/completeById";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void multipleDeleteById(List<long?> arg0 )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_multipleDelete";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Ack updateById(long? id, net.bluemind.notes.api.VNote arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.notes.api.VNote));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteById(long? id )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Ack createById(long? id, net.bluemind.notes.api.VNote arg1 )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.notes.api.VNote));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<long?> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_sorted";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.SortDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> allUids()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_all";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.notes.api.VNote note )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.notes.api.VNote));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, note);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerUpdatesResult updates(net.bluemind.notes.api.VNoteChanges changes )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_mupdates";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.notes.api.VNoteChanges));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, changes);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerUpdatesResult>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> search(net.bluemind.notes.api.VNoteQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.notes.api.VNoteQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.notes.api.VNote note )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.notes.api.VNote));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, note);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> all()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> multipleGet(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void reset()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_reset";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
