/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.mailbox.api.IMailboxes.
 */
namespace net.bluemind.mailbox.api
{

  public class MailboxesClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public MailboxesClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/mailboxes/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public net.bluemind.mailbox.api.MailboxConfig getMailboxConfig(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_config";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailboxConfig>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.mailbox.api.Mailbox mailbox )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.Mailbox));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, mailbox);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> byName(String name )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_byname";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("name", name.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setMailboxFilter(String mailboxUid, net.bluemind.mailbox.api.MailFilter filter )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_filter";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.MailFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, filter);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public int? getUnreadMessagesCount()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_unread";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<int?>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> listUids()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_listUids";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setMailboxAccessControlList(String mailboxUid, List<net.bluemind.core.container.model.acl.AccessControlEntry> accessControlEntries )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_acls";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.core.container.model.acl.AccessControlEntry>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, accessControlEntries);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> byEmail(String email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_byemail";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("email", email.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.mailbox.api.Mailbox mailbox )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.Mailbox));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, mailbox);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> byRouting(net.bluemind.mailbox.api.MailboxRouting email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_byRouting";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("email", email.ToString());

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef checkAll()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_check-all";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> multipleGet(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef checkAndRepair(String uid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_check-and-repair";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.MailFilter getMailboxFilter(String mailboxUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_filter";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailFilter>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.acl.AccessControlEntry> getMailboxAccessControlList(String mailboxUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_acls";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.acl.AccessControlEntry>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef check(String uid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_check";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> list()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_list";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setDomainFilter(net.bluemind.mailbox.api.MailFilter filter )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_filter";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.MailFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, filter);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.MailboxQuota getMailboxQuota(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_quota";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailboxQuota>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.MailFilter getDomainFilter()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_filter";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailFilter>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> byType(net.bluemind.mailbox.api.MailboxType email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_byType";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("email", email.ToString());

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef checkAndRepairAll()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_check-and-repair-all";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
