/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.im.api.IInstantMessaging.
 */
namespace net.bluemind.im.api
{

  public class InstantMessagingClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public InstantMessagingClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/im";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public List<net.bluemind.im.api.IMMessage> getLastMessagesBetween(String user1, String user2, int? messagesCount )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_getLastMessagesBetween";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("user1", user1.ToString());
      queryParams.Add("user2", user2.ToString());
      queryParams.Add("messagesCount", messagesCount.ToString());

      dynamic body = null;
      return this.execute<List<net.bluemind.im.api.IMMessage>>(methodPathValue, queryParams, body, methodVerb);
    }
    public Boolean isActiveUser(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_activeUser/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Boolean>(methodPathValue, queryParams, body, methodVerb);
    }
    public void sendGroupChatHistory(String sender, String groupChatId, List<String> recipients )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_sendGroupChatHistory/{groupChatId}";
      methodPathValue = methodPathValue.Replace("{groupChatId}", HttpUtility.UrlEncode("" + groupChatId));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("sender", sender.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, recipients);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setRoster(String jabberId, String data )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_setRoster";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("jabberId", jabberId.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, data);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getRoster(String jabberId )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_getRoster";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("jabberId", jabberId.ToString());

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
