/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.hsm.api.IHSM.
 */
namespace net.bluemind.hsm.api
{

  public class HSMClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public HSMClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/hsm/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public List<net.bluemind.hsm.api.TierChangeResult> promoteMultiple(List<net.bluemind.hsm.api.Promote> promote )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_massPromote";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.hsm.api.Promote>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, promote);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.hsm.api.TierChangeResult>>(methodPathValue, queryParams, body, methodVerb);
    }
    public double? getSize(String mailboxUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_getSize/{mailboxUid}";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<double?>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] fetch(String mailboxUid, String hsmId )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_fetch/{mailboxUid}/{hsmId}";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));
      methodPathValue = methodPathValue.Replace("{hsmId}", HttpUtility.UrlEncode("" + hsmId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public void copy(String sourceMailboxUid, String destMailboxUid, List<String> hsmIds )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_copy/{sourceMailboxUid}/{destMailboxUid}";
      methodPathValue = methodPathValue.Replace("{sourceMailboxUid}", HttpUtility.UrlEncode("" + sourceMailboxUid));
      methodPathValue = methodPathValue.Replace("{destMailboxUid}", HttpUtility.UrlEncode("" + destMailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, hsmIds);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
