/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.filehosting.api.IInternalBMFileSystem.
 */
namespace net.bluemind.filehosting.api
{

  public class InternalBMFileSystemClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public InternalBMFileSystemClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/bmfilehosting";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public List<String> getShareUidsByPath(String path )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_shares";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, path);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
