/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.filehosting.api
{
  [DataContract(Namespace="")]
  public partial class FileHostingItem  {
    [DataMember]
    public String path;
    
    [DataMember]
    public String name;
    
    [IgnoreDataMember]
    public net.bluemind.filehosting.api.FileType? type;
    [DataMember(Name = "type")]
    public String typeSurrogate
    {
        get
        {
            return type.HasValue ? type.ToString() : null;
        }
        set
        {
            net.bluemind.filehosting.api.FileType e;
            type = Enum.TryParse(value, true, out e) ? e : (net.bluemind.filehosting.api.FileType?)null;
        }
    }
    
    [DataMember]
    public long? size;
    
    [DataMember]
    public List<net.bluemind.filehosting.api.Metadata> metadata = new List<net.bluemind.filehosting.api.Metadata>();
    
  
  }
}
