/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.filehosting.api.IFileHosting.
 */
namespace net.bluemind.filehosting.api
{

  public class FileHostingClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public FileHostingClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/filehosting/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public void store(String path, Stream document )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{path}";
      methodPathValue = methodPathValue.Replace("{path}", HttpUtility.UrlEncode("" + path));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = document;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.filehosting.api.FileHostingItem> list(String path )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_list";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("path", path.ToString());

      dynamic body = null;
      return this.execute<List<net.bluemind.filehosting.api.FileHostingItem>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String path )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{path}";
      methodPathValue = methodPathValue.Replace("{path}", HttpUtility.UrlEncode("" + path));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.filehosting.api.FileHostingItem getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.filehosting.api.FileHostingItem>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.filehosting.api.Configuration getConfiguration()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_config";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.filehosting.api.Configuration>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.filehosting.api.FileHostingItem> find(String query )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_find";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("query", query.ToString());

      dynamic body = null;
      return this.execute<List<net.bluemind.filehosting.api.FileHostingItem>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void unShare(String url )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{url}/unshare";
      methodPathValue = methodPathValue.Replace("{url}", HttpUtility.UrlEncode("" + url));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public Stream get(String path )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{path}/_content";
      methodPathValue = methodPathValue.Replace("{path}", HttpUtility.UrlEncode("" + path));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Stream>(methodPathValue, queryParams, body, methodVerb);
    }
    public Stream getSharedFile(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_public";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Stream>(methodPathValue, queryParams, body, methodVerb);
    }
    public Boolean exists(String path )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{path}/_exists";
      methodPathValue = methodPathValue.Replace("{path}", HttpUtility.UrlEncode("" + path));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Boolean>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.filehosting.api.FileHostingPublicLink share(String path, int? downloadLimit, String expirationDate )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_share";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("path", path.ToString());
      queryParams.Add("downloadLimit", downloadLimit.ToString());
      queryParams.Add("expirationDate", expirationDate.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.filehosting.api.FileHostingPublicLink>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.filehosting.api.FileHostingInfo info()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_info";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.filehosting.api.FileHostingInfo>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
