/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.externaluser.api.IExternalUser.
 */
namespace net.bluemind.externaluser.api
{

  public class ExternalUserClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public ExternalUserClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/externaluser/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> memberOf(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/groups";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> memberOfGroups(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/groupUids";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser> byExtId(String extid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byExtId/{extid}";
      methodPathValue = methodPathValue.Replace("{extid}", HttpUtility.UrlEncode("" + extid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.externaluser.api.ExternalUser externalUser )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.externaluser.api.ExternalUser));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, externalUser);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.externaluser.api.ExternalUser externalUser )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.externaluser.api.ExternalUser));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, externalUser);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void createWithExtId(String uid, String extid, net.bluemind.externaluser.api.ExternalUser externalUser )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}/{extid}/createwithextid";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));
      methodPathValue = methodPathValue.Replace("{extid}", HttpUtility.UrlEncode("" + extid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.externaluser.api.ExternalUser));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, externalUser);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
