/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.document.api.IDocument.
 */
namespace net.bluemind.document.api
{

  public class DocumentClient : BMClient
  {
    private String containerUid;
    private String itemUid;
  
    /*
     * Constructor 
     */
    public DocumentClient(String baseUrl, String sid , String containerUid , String itemUid )
    {
      this.baseUrl = baseUrl + "/api/document/{containerUid}/{itemUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.itemUid = itemUid;
      this.baseUrl = this.baseUrl.Replace("{itemUid}", itemUid);
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public void update(String uid, net.bluemind.document.api.Document doc )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.document.api.Document));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, doc);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.document.api.DocumentMetadata> list()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_list";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.document.api.DocumentMetadata>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.document.api.DocumentMetadata fetchMetadata(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/metadata";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.document.api.DocumentMetadata>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.document.api.Document fetch(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.document.api.Document>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.document.api.Document doc )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.document.api.Document));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, doc);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
