/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.directory.api.IOrgUnits.
 */
namespace net.bluemind.directory.api
{

  public class OrgUnitsClient : BMClient
  {
    private String domain;
  
    /*
     * Constructor 
     */
    public OrgUnitsClient(String baseUrl, String sid , String domain )
    {
      this.baseUrl = baseUrl + "/api/directory/_ou/{domain}";      
      this.sid = sid;
      this.domain = domain;
      this.baseUrl = this.baseUrl.Replace("{domain}", domain);
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public List<String> getAdministratorRoles(String uid, String dirUid, List<String> groups )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/{dirUid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));
      methodPathValue = methodPathValue.Replace("{dirUid}", HttpUtility.UrlEncode("" + dirUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, groups);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setAdministratorRoles(String uid, String dirUid, List<String> roles )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/{dirUid}/_set";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));
      methodPathValue = methodPathValue.Replace("{dirUid}", HttpUtility.UrlEncode("" + dirUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, roles);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.directory.api.OrgUnit value )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.directory.api.OrgUnit));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, value);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void removeAdministrator(String administrator )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_deleteadmin";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("administrator", administrator.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getAdministrators(String uid, Boolean hierarchical )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_administrators";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("hierarchical", hierarchical.ToString());

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>> getChildren(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_children";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.directory.api.OrgUnitPath> search(net.bluemind.directory.api.OrgUnitQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.directory.api.OrgUnitQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.directory.api.OrgUnitPath>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.directory.api.OrgUnitPath getPath(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/path";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.directory.api.OrgUnitPath>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.directory.api.OrgUnit value )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.directory.api.OrgUnit));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, value);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.directory.api.OrgUnitPath> listByAdministrator(String administrator, List<String> groups )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_byAdmin";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("administrator", administrator.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, groups);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.directory.api.OrgUnitPath>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
