/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.directory.api
{
  [DataContract(Namespace="")]
  public partial class OrgUnitQuery  {
    [DataMember]
    public int? from;
    
    [DataMember]
    public int? size;
    
    [DataMember]
    public String query;
    
    [IgnoreDataMember]
    public List<net.bluemind.directory.api.BaseDirEntryKind> managableKinds = new List<net.bluemind.directory.api.BaseDirEntryKind>();
    [DataMember(Name = "managableKinds")]
    public List<String> managableKindsSurrogate
    {
        get
        {
            return managableKinds == null ? null : managableKinds.Select(v => v.ToString()).ToList();
        }
        set
        {
            managableKinds = new List<net.bluemind.directory.api.BaseDirEntryKind>();
            foreach (string s in value)
            {
                net.bluemind.directory.api.BaseDirEntryKind e;
                if (Enum.TryParse(s, true, out e))
                {
                    managableKinds.Add(e);
                }
            }            
        }
    }
    
  
  }
}
