/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.dataprotect.api
{
  [DataContract(Namespace="")]
  public partial class PartGeneration  {
    [DataMember]
    public int? id;
    
    [DataMember]
    public int? generationId;
    
    [IgnoreDataMember]
    public System.DateTime? begin;
    [DataMember(Name = "begin")]
    public String beginSurrogate
    {
      get
      {
        return (begin != null)
          ? "" + Math.Floor((((DateTime)begin) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          begin = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          begin = null;
        }
      }
    }
    
    [IgnoreDataMember]
    public System.DateTime? end;
    [DataMember(Name = "end")]
    public String endSurrogate
    {
      get
      {
        return (end != null)
          ? "" + Math.Floor((((DateTime)end) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          end = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          end = null;
        }
      }
    }
    
    [DataMember]
    public long? size;
    
    [DataMember]
    public String tag;
    
    [DataMember]
    public String server;
    
    [DataMember]
    public Boolean withWarnings;
    
    [DataMember]
    public Boolean withErrors;
    
    [IgnoreDataMember]
    public net.bluemind.dataprotect.api.GenerationStatus? valid;
    [DataMember(Name = "valid")]
    public String validSurrogate
    {
        get
        {
            return valid.HasValue ? valid.ToString() : null;
        }
        set
        {
            net.bluemind.dataprotect.api.GenerationStatus e;
            valid = Enum.TryParse(value, true, out e) ? e : (net.bluemind.dataprotect.api.GenerationStatus?)null;
        }
    }
    
    [DataMember]
    public String datatype;
    
  
  }
}
