/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.dataprotect.api
{
  [DataContract(Namespace="")]
  public partial class DataProtectGeneration  {
    [DataMember]
    public int? id;
    
    [IgnoreDataMember]
    public System.DateTime? protectionTime;
    [DataMember(Name = "protectionTime")]
    public String protectionTimeSurrogate
    {
      get
      {
        return (protectionTime != null)
          ? "" + Math.Floor((((DateTime)protectionTime) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          protectionTime = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          protectionTime = null;
        }
      }
    }
    
    [DataMember]
    public net.bluemind.core.api.VersionInfo blueMind = new net.bluemind.core.api.VersionInfo();
    
    [DataMember]
    public Boolean withWarnings;
    
    [DataMember]
    public Boolean withErrors;
    
    [DataMember]
    public List<net.bluemind.dataprotect.api.PartGeneration> parts = new List<net.bluemind.dataprotect.api.PartGeneration>();
    
  
  }
}
