/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.core.container.model
{
  [DataContract(Namespace="")]
  public partial class ItemValue<T>  {
    [DataMember]
    public T value;
    
    [DataMember]
    public String uid;
    
    [DataMember]
    public long? internalId;
    
    [DataMember]
    public long? version;
    
    [DataMember]
    public String displayName;
    
    [DataMember]
    public String externalId;
    
    [DataMember]
    public String createdBy;
    
    [DataMember]
    public String updatedBy;
    
    [IgnoreDataMember]
    public System.DateTime? created;
    [DataMember(Name = "created")]
    public String createdSurrogate
    {
      get
      {
        return (created != null)
          ? "" + Math.Floor((((DateTime)created) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          created = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          created = null;
        }
      }
    }
    
    [IgnoreDataMember]
    public System.DateTime? updated;
    [DataMember(Name = "updated")]
    public String updatedSurrogate
    {
      get
      {
        return (updated != null)
          ? "" + Math.Floor((((DateTime)updated) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          updated = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          updated = null;
        }
      }
    }
    
    [IgnoreDataMember]
    public List<net.bluemind.core.container.model.ItemFlag> flags = new List<net.bluemind.core.container.model.ItemFlag>();
    [DataMember(Name = "flags")]
    public List<String> flagsSurrogate
    {
        get
        {
            return flags == null ? null : flags.Select(v => v.ToString()).ToList();
        }
        set
        {
            flags = new List<net.bluemind.core.container.model.ItemFlag>();
            foreach (string s in value)
            {
                net.bluemind.core.container.model.ItemFlag e;
                if (Enum.TryParse(s, true, out e))
                {
                    flags.Add(e);
                }
            }            
        }
    }
    
  
  }
}
