/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.calendar.api.IUserCalendarViews.
 */
namespace net.bluemind.calendar.api
{

  public class UserCalendarViewsClient : BMClient
  {
    private String domainUid;
    private String userUid;
  
    /*
     * Constructor 
     */
    public UserCalendarViewsClient(String baseUrl, String sid , String domainUid , String userUid )
    {
      this.baseUrl = baseUrl + "/api/users/{domainUid}/{userUid}/calendar-views";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.userUid = userUid;
      this.baseUrl = this.baseUrl.Replace("{userUid}", userUid);
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>> multipleGet(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.calendar.api.CalendarView view )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.calendar.api.CalendarView));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, view);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>> list()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_list";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updates(net.bluemind.calendar.api.CalendarViewChanges changes )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_mupdates";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.calendar.api.CalendarViewChanges));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, changes);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setDefault(String uid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_asdefault";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.calendar.api.CalendarView view )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.calendar.api.CalendarView));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, view);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>> multipleGetById(List<long?> arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mgetById";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView> getCompleteById(long? id )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{id}/completeById";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>(methodPathValue, queryParams, body, methodVerb);
    }
    public long? getVersion()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_version";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<long?>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> filteredChangesetById(long? since, net.bluemind.core.container.model.ItemFlagFilter arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_filteredChangesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ItemFlagFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemChangelog itemChangelog(String uid, long? arg1 )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_itemchangelog";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(long?));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ItemChangelog>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<String> changeset(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changeset";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<long?> changesetById(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangelog containerChangelog(long? arg0 )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changelog";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(long?));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerChangelog>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<long?> allIds(String filter, long? knownContainerVersion, int? limit, int? offset )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_itemIds";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("filter", filter.ToString());
      queryParams.Add("knownContainerVersion", knownContainerVersion.ToString());
      queryParams.Add("limit", limit.ToString());
      queryParams.Add("offset", offset.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.api.ListResult<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
