/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.calendar.api
{
  [DataContract(Namespace="")]
  public partial class PrintOptions  {
    [IgnoreDataMember]
    public net.bluemind.calendar.api.PrintOptionsPrintView? view;
    [DataMember(Name = "view")]
    public String viewSurrogate
    {
        get
        {
            return view.HasValue ? view.ToString() : null;
        }
        set
        {
            net.bluemind.calendar.api.PrintOptionsPrintView e;
            view = Enum.TryParse(value, true, out e) ? e : (net.bluemind.calendar.api.PrintOptionsPrintView?)null;
        }
    }
    
    [IgnoreDataMember]
    public net.bluemind.calendar.api.PrintOptionsPrintFormat? format;
    [DataMember(Name = "format")]
    public String formatSurrogate
    {
        get
        {
            return format.HasValue ? format.ToString() : null;
        }
        set
        {
            net.bluemind.calendar.api.PrintOptionsPrintFormat e;
            format = Enum.TryParse(value, true, out e) ? e : (net.bluemind.calendar.api.PrintOptionsPrintFormat?)null;
        }
    }
    
    [DataMember]
    public net.bluemind.core.api.date.BmDateTime dateBegin = new net.bluemind.core.api.date.BmDateTime();
    
    [DataMember]
    public net.bluemind.core.api.date.BmDateTime dateEnd = new net.bluemind.core.api.date.BmDateTime();
    
    [DataMember]
    public Boolean color;
    
    [DataMember]
    public Boolean showDetail;
    
    [IgnoreDataMember]
    public net.bluemind.calendar.api.PrintOptionsPrintLayout? layout;
    [DataMember(Name = "layout")]
    public String layoutSurrogate
    {
        get
        {
            return layout.HasValue ? layout.ToString() : null;
        }
        set
        {
            net.bluemind.calendar.api.PrintOptionsPrintLayout e;
            layout = Enum.TryParse(value, true, out e) ? e : (net.bluemind.calendar.api.PrintOptionsPrintLayout?)null;
        }
    }
    
    [DataMember]
    public List<net.bluemind.calendar.api.PrintOptionsCalendarMetadata> calendars = new List<net.bluemind.calendar.api.PrintOptionsCalendarMetadata>();
    
    [DataMember]
    public List<String> tagsFilter = new List<String>();
    
  
  }
}
