/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.calendar.api
{
  [DataContract(Namespace="")]
  public partial class CalendarLookupResponse  {
    [DataMember]
    public String uid;
    
    [DataMember]
    public String name;
    
    [IgnoreDataMember]
    public net.bluemind.calendar.api.CalendarLookupResponseType? type;
    [DataMember(Name = "type")]
    public String typeSurrogate
    {
        get
        {
            return type.HasValue ? type.ToString() : null;
        }
        set
        {
            net.bluemind.calendar.api.CalendarLookupResponseType e;
            type = Enum.TryParse(value, true, out e) ? e : (net.bluemind.calendar.api.CalendarLookupResponseType?)null;
        }
    }
    
    [DataMember]
    public String email;
    
    [DataMember]
    public int? memberCount;
    
    [DataMember]
    public String ownerUid;
    
  
  }
}
