/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.authentication.api.IUserAccessToken.
 */
namespace net.bluemind.authentication.api
{

  public class UserAccessTokenClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public UserAccessTokenClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/auth/access_token";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "4.9.3879";
    }
    
    public net.bluemind.authentication.api.AccessTokenInfo authCodeReceived(String state, String code )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_auth";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("state", state.ToString());
      queryParams.Add("code", code.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.authentication.api.AccessTokenInfo>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.AccessTokenInfo getTokenInfo(String external_system, String baseUrl )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_info";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("external_system", external_system.ToString());
      queryParams.Add("baseUrl", baseUrl.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.authentication.api.AccessTokenInfo>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
