/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.addressbook.api
{
  [DataContract(Namespace="")]
  public partial class VCard  {
    [IgnoreDataMember]
    public net.bluemind.addressbook.api.VCardKind? kind;
    [DataMember(Name = "kind")]
    public String kindSurrogate
    {
        get
        {
            return kind.HasValue ? kind.ToString() : null;
        }
        set
        {
            net.bluemind.addressbook.api.VCardKind e;
            kind = Enum.TryParse(value, true, out e) ? e : (net.bluemind.addressbook.api.VCardKind?)null;
        }
    }
    
    [DataMember]
    public String source;
    
    [DataMember]
    public net.bluemind.addressbook.api.VCardIdentification identification = new net.bluemind.addressbook.api.VCardIdentification();
    
    [DataMember]
    public List<net.bluemind.addressbook.api.VCardDeliveryAddressing> deliveryAddressing = new List<net.bluemind.addressbook.api.VCardDeliveryAddressing>();
    
    [DataMember]
    public net.bluemind.addressbook.api.VCardCommunications communications = new net.bluemind.addressbook.api.VCardCommunications();
    
    [DataMember]
    public net.bluemind.addressbook.api.VCardOrganizational organizational = new net.bluemind.addressbook.api.VCardOrganizational();
    
    [DataMember]
    public net.bluemind.addressbook.api.VCardExplanatory explanatory = new net.bluemind.addressbook.api.VCardExplanatory();
    
    [DataMember]
    public net.bluemind.addressbook.api.VCardSecurity security = new net.bluemind.addressbook.api.VCardSecurity();
    
    [DataMember]
    public net.bluemind.addressbook.api.VCardRelated related = new net.bluemind.addressbook.api.VCardRelated();
    
  
  }
}
