/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailmessage.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailTipsGwtSerDer implements GwtSerDer<net.bluemind.mailmessage.api.MailTips> {

	public MailTipsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailmessage.api.MailTips deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailmessage.api.MailTips ret = new net.bluemind.mailmessage.api.MailTips();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailmessage.api.MailTips ret, JSONObject json) {

		JSONValue forRecipientJSON = json.get("forRecipient");
		ret.forRecipient =  new net.bluemind.mailflow.common.api.gwt.serder.RecipientGwtSerDer().deserialize(forRecipientJSON);
		JSONValue matchingTipsJSON = json.get("matchingTips");
		ret.matchingTips =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailmessage.api.gwt.serder.MailTipGwtSerDer()).deserialize(matchingTipsJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailmessage.api.MailTips o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailmessage.api.MailTips o, JSONObject ret) {

		ret.put("forRecipient",  new net.bluemind.mailflow.common.api.gwt.serder.RecipientGwtSerDer().serialize( o.forRecipient ));
		ret.put("matchingTips",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailmessage.api.gwt.serder.MailTipGwtSerDer()).serialize( o.matchingTips ));
	}
}