import Vue from "vue";
import { SEND_MESSAGE } from "~/actions";
import { ADDRESS_AUTOCOMPLETE } from "~/getters";
import { ADD_ADDRESS_WEIGHT, DELETE_ADDRESS_WEIGHTS, SET_ADDRESS_WEIGHT, SET_ADDRESS_WEIGHTS } from "~/mutations";

export default {
    state: {
        addressWeights: {}
    },

    mutations: {
        [ADD_ADDRESS_WEIGHT]: (state, { address, weight }) => {
            Vue.set(state.addressWeights, address, (state.addressWeights[address] || 0) + weight);
        },
        [SET_ADDRESS_WEIGHT]: (state, { address, weight }) => {
            Vue.set(state.addressWeights, address, weight);
        },
        [SET_ADDRESS_WEIGHTS]: (state, addressWeights) => {
            state.addressWeights = addressWeights;
        },
        [DELETE_ADDRESS_WEIGHTS]: state => {
            state.addressWeights = {};
        }
    },

    getters: {
        [ADDRESS_AUTOCOMPLETE]: state => {
            const addressAutoComplete = { sortedAddresses: [], excludedAddresses: [] };
            Object.keys(state.addressWeights).forEach(address => {
                state.addressWeights[address] >= 0
                    ? addressAutoComplete.sortedAddresses.push(address)
                    : addressAutoComplete.excludedAddresses.push(address);
            });
            addressAutoComplete.sortedAddresses.sort((a, b) => state.addressWeights[b] - state.addressWeights[a]);
            return addressAutoComplete;
        }
    },

    actions: {
        [ADD_ADDRESS_WEIGHT]: (store, { address, weight }) => {
            store.commit(ADD_ADDRESS_WEIGHT, { address, weight });
            syncAppData(store);
        },
        [SET_ADDRESS_WEIGHT]: (store, { address, weight }) => {
            store.commit(SET_ADDRESS_WEIGHT, { address, weight });
            syncAppData(store);
        },
        [DELETE_ADDRESS_WEIGHTS]: store => {
            store.commit(DELETE_ADDRESS_WEIGHTS);
            syncAppData(store);
        },
        [SEND_MESSAGE]: (store, { draft }) => {
            const sentAddresses = new Set(
                draft.to
                    .concat(draft.cc)
                    .concat(draft.bcc)
                    .map(({ address }) => address)
            );
            const weight = new Date().getTime();
            sentAddresses.forEach(address => store.dispatch(ADD_ADDRESS_WEIGHT, { address, weight }));
        }
    }
};

/**
 * /!\ temp code: useless in 5.0 version due to 'synced' system
 */
function syncAppData(store) {
    return store.dispatch(
        `root-app/SET_APP_DATA`,
        {
            key: "mail:address_autocomplete:address_weights",
            value: store.state.addressWeights
        },
        { root: true }
    );
}
