package net.bluemind.exchange.mapi.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.exchange.mapi.api.IMapiFolderAsync.class)
public interface IMapiFolderPromise  {

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.exchange.mapi.api.MapiRawMessage>>> multipleGetById(java.util.List<java.lang.Long> arg0);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.exchange.mapi.api.MapiRawMessage>> getCompleteById(long id);

	CompletableFuture<Void> multipleDeleteById(java.util.List<java.lang.Long> arg0);

	CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id, net.bluemind.exchange.mapi.api.MapiRawMessage arg1);

	CompletableFuture<Void> deleteById(long id);

	CompletableFuture<net.bluemind.core.container.api.Ack> createById(long id, net.bluemind.exchange.mapi.api.MapiRawMessage arg1);

	CompletableFuture<Long> getVersion();

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(java.lang.Long since, net.bluemind.core.container.model.ItemFlagFilter arg1);

	CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(java.lang.String uid, java.lang.Long arg1);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> changeset(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.Long>> changesetById(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> containerChangelog(java.lang.Long arg0);

	CompletableFuture<net.bluemind.core.api.ListResult<java.lang.Long>> allIds(java.lang.String filter, java.lang.Long knownContainerVersion, java.lang.Integer limit, java.lang.Integer offset);

	CompletableFuture<net.bluemind.core.container.api.Count> count(net.bluemind.core.container.model.ItemFlagFilter arg0);

	CompletableFuture<java.util.List<java.lang.Long>> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0);

	CompletableFuture<Void> reset();

}