package net.bluemind.cli.index;

public class FolderIncoherency {
	private final String uid;
	private final long esCount;
	private final long dbCount;

	public FolderIncoherency(String uid, long esCount, long dbCount) {
		this.uid = uid;
		this.esCount = esCount;
		this.dbCount = dbCount;
	}

	public String uid() {
		return uid;
	}

	public long dbCount() {
		return dbCount;
	}

	public long esCount() {
		return esCount;
	}

	public boolean missingInEs() {
		return esCount == -1;
	}

	public boolean missingInDb() {
		return dbCount == -1;
	}

	public boolean divergent() {
		return dbCount != -1 && esCount != -1;
	}
}
