package net.bluemind.cli.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import net.bluemind.backend.mail.api.MailboxFolder;
import net.bluemind.core.container.model.ItemValue;

public class EsReport {
	private final boolean missingAlias;
	private final long missingParentCount;
	private final boolean isArchived;
	private final List<FolderIncoherency> incoherencies = new ArrayList<>();
	private final Map<String, ItemValue<MailboxFolder>> mailboxesByUid;

	public EsReport(boolean missingAlias, boolean isArchived) {
		this.missingAlias = missingAlias;
		this.missingParentCount = 0;
		this.isArchived = isArchived;
		this.mailboxesByUid = new HashMap<>();
	}

	public EsReport(long missingParentCount, boolean isArchived, Map<String, ItemValue<MailboxFolder>> mailboxesByUid) {
		this.missingAlias = false;
		this.missingParentCount = missingParentCount;
		this.isArchived = isArchived;
		this.mailboxesByUid = mailboxesByUid;
	}

	public boolean missingAlias() {
		return missingAlias;
	}

	public long missingParentCount() {
		return missingParentCount;
	}

	public Map<String, ItemValue<MailboxFolder>> mailboxesByUid() {
		return mailboxesByUid;
	}

	public boolean hasIncoherency() {
		return missingAlias || missingParentCount > 0 || incoherencies.size() > 0;
	}

	public boolean isArchived() {
		return this.isArchived;
	}

	public List<FolderIncoherency> missingInEs() {
		return incoherencies.stream().filter(FolderIncoherency::missingInEs).collect(Collectors.toList());
	}

	public List<FolderIncoherency> missingInDb() {
		return incoherencies.stream().filter(FolderIncoherency::missingInDb).collect(Collectors.toList());
	}

	public List<FolderIncoherency> divergent() {
		return incoherencies.stream().filter(FolderIncoherency::divergent).collect(Collectors.toList());
	}

	public void addDivergent(String uid, long esCount, long dbCount) {
		incoherencies.add(new FolderIncoherency(uid, esCount, dbCount));
	}

	public void addMissingInEs(String uid, long dbCount) {
		incoherencies.add(new FolderIncoherency(uid, -1, dbCount));
	}

	public void addMissingInDb(String uid, long esCount) {
		incoherencies.add(new FolderIncoherency(uid, esCount, -1));
	}

}