/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.role.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RoleDescriptorGwtSerDer implements GwtSerDer<net.bluemind.role.api.RoleDescriptor> {

	public RoleDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.role.api.RoleDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.role.api.RoleDescriptor ret = new net.bluemind.role.api.RoleDescriptor();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.role.api.RoleDescriptor ret, JSONObject json) {

		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		JSONValue parentRoleIdJSON = json.get("parentRoleId");
		ret.parentRoleId =  GwtSerDerUtils.STRING.deserialize(parentRoleIdJSON);
		JSONValue categoryIdJSON = json.get("categoryId");
		ret.categoryId =  GwtSerDerUtils.STRING.deserialize(categoryIdJSON);
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue selfPromoteJSON = json.get("selfPromote");
		ret.selfPromote =  GwtSerDerUtils.BOOLEAN.deserialize(selfPromoteJSON);
		JSONValue dirEntryPromoteJSON = json.get("dirEntryPromote");
		ret.dirEntryPromote =  GwtSerDerUtils.BOOLEAN.deserialize(dirEntryPromoteJSON);
		JSONValue dirEntryKindJSON = json.get("dirEntryKind");
		ret.dirEntryKind =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().deserialize(dirEntryKindJSON);
		JSONValue siblingRoleJSON = json.get("siblingRole");
		ret.siblingRole =  GwtSerDerUtils.STRING.deserialize(siblingRoleJSON);
		JSONValue childsRoleJSON = json.get("childsRole");
		ret.childsRole =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(childsRoleJSON);
		JSONValue visibleJSON = json.get("visible");
		ret.visible =  GwtSerDerUtils.BOOLEAN.deserialize(visibleJSON);
		JSONValue delegableJSON = json.get("delegable");
		ret.delegable =  GwtSerDerUtils.BOOLEAN.deserialize(delegableJSON);
		JSONValue containerRolesJSON = json.get("containerRoles");
		ret.containerRoles =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(containerRolesJSON);
		JSONValue priorityJSON = json.get("priority");
		ret.priority =  GwtSerDerUtils.INT.deserialize(priorityJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.role.api.RoleDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.role.api.RoleDescriptor o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		ret.put("parentRoleId",  GwtSerDerUtils.STRING.serialize( o.parentRoleId ));
		ret.put("categoryId",  GwtSerDerUtils.STRING.serialize( o.categoryId ));
		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("selfPromote",  GwtSerDerUtils.BOOLEAN.serialize( o.selfPromote ));
		ret.put("dirEntryPromote",  GwtSerDerUtils.BOOLEAN.serialize( o.dirEntryPromote ));
		ret.put("dirEntryKind",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().serialize( o.dirEntryKind ));
		ret.put("siblingRole",  GwtSerDerUtils.STRING.serialize( o.siblingRole ));
		ret.put("childsRole",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.childsRole ));
		ret.put("visible",  GwtSerDerUtils.BOOLEAN.serialize( o.visible ));
		ret.put("delegable",  GwtSerDerUtils.BOOLEAN.serialize( o.delegable ));
		ret.put("containerRoles",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.containerRoles ));
		ret.put("priority",  GwtSerDerUtils.INT.serialize( o.priority ));
	}
}