/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.role.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class RolesSockJsEndpoint implements net.bluemind.role.api.IRolesAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public RolesSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/roles";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public RolesSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void getRolesCategories(final AsyncHandler<Set<net.bluemind.role.api.RolesCategory>> handler) {
		String postUri = "/categories";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Set<net.bluemind.role.api.RolesCategory>>(handler) {
					@Override
			protected Set<net.bluemind.role.api.RolesCategory> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(new net.bluemind.role.api.gwt.serder.RolesCategoryGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getRoles(final AsyncHandler<Set<net.bluemind.role.api.RoleDescriptor>> handler) {
		String postUri = "/descriptors";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Set<net.bluemind.role.api.RoleDescriptor>>(handler) {
					@Override
			protected Set<net.bluemind.role.api.RoleDescriptor> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(new net.bluemind.role.api.gwt.serder.RoleDescriptorGwtSerDer()).deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.role.api.IRolesPromise promiseApi() {
		return new RolesEndpointPromise(this);
	}

}
