/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.ldap.importation.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class LdapImportGwtEndpoint implements net.bluemind.system.ldap.importation.api.ILdapImportAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public LdapImportGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/ldapimport";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public LdapImportGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void testParameters(String hostname, String protocol, String allCertificate, String basedn, String logindn, String password, String userfilter, String groupfilter, final AsyncHandler<Void> handler) {
		String postUri = "/_testparameters";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&hostname=" + com.google.gwt.http.client.URL.encodeQueryString(""+hostname);
		queryParams += "&protocol=" + com.google.gwt.http.client.URL.encodeQueryString(""+protocol);
		queryParams += "&allCertificate=" + com.google.gwt.http.client.URL.encodeQueryString(""+allCertificate);
		queryParams += "&basedn=" + com.google.gwt.http.client.URL.encodeQueryString(""+basedn);
		queryParams += "&logindn=" + com.google.gwt.http.client.URL.encodeQueryString(""+logindn);
		queryParams += "&password=" + com.google.gwt.http.client.URL.encodeQueryString(""+password);
		queryParams += "&userfilter=" + com.google.gwt.http.client.URL.encodeQueryString(""+userfilter);
		queryParams += "&groupfilter=" + com.google.gwt.http.client.URL.encodeQueryString(""+groupfilter);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void fullSync(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/_fullsync";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.system.ldap.importation.api.ILdapImportPromise promiseApi() {
		return new LdapImportEndpointPromise(this);
	}
}
